//==============================================
// CSS38F20 Special Register Address Definition
// Date:2019-10-11
// Version: V1.0.0 
//==============================================

#ifndef  _CSU38F20_H
#define  _CSU38F20_H 1

//Data Memory Organization 00h-08h
extern volatile unsigned char IND0             @ 0x00;     //{  }
extern volatile unsigned char FSR0             @ 0x02;     //{  }
extern volatile unsigned char STATUS           @ 0x04;     //{ 0, 0, 0, PD, TO, DC, C, Z }
extern volatile unsigned char WORK             @ 0x05;     //{  }
extern volatile unsigned char INTF             @ 0x06;     //{ 0, TM2IF, 0, TM0IF, SRADIF, 0, E1IF, E0IF }
extern volatile unsigned char INTE             @ 0x07;     //{ GIE, TM2IE, 0, TM0IE, SRADIE, 0, E1IE, E0IE }
extern volatile unsigned char BSR              @ 0x08;     //{ IRP0, 0, 0, 0, 0, 0, 0, PAGE[0:0] }

//Peripheral special registers 09h-7Ch
extern volatile unsigned char RSTSR            @ 0x09;     //{ 0, 0, 0, 0, 0, EMCF, ILOPF, WWDTF }
extern volatile unsigned char EADRH            @ 0x0A;     //{ EADR[15:8] }
extern volatile unsigned char EADRL            @ 0x0B;     //{ EADR[7:0] }
extern volatile unsigned char EDATH            @ 0x0C;     //{ EDATH[7:0] }
extern volatile unsigned char WDTCON           @ 0x0D;     //{ WDTEN, 0, 0, 0, 0, WTS[2:0] }
extern volatile unsigned char WDTIN            @ 0x0E;     //{ WDTIN[7:0] }
extern volatile unsigned char TM0CON           @ 0x0F;     //{ T0EN, T0RATE[2:0], 0, T0RSTB, T0SEL[1:0] }
extern volatile unsigned char TM0IN            @ 0x10;     //{ TM0IN[7:0] }
extern volatile unsigned char TM0CNT           @ 0x11;     //{ TM0CNT[7:0] }
extern volatile unsigned char PAGECTL          @ 0x14;     //{ 0, 0, 0, 0, 0, 0, 0, PAGE2 }
extern volatile unsigned char MCK              @ 0x16;     //{ 0, 0, CST_WDT, 0, 0, 0, 0, 0 }
extern volatile unsigned char TM2CON           @ 0x17;     //{ T2EN, T2RATE[2:0], T2CKS, T2RSTB, T2OUT, PWM2OUT }
extern volatile unsigned char TM2IN            @ 0x18;     //{ TM2IN[7:0] }
extern volatile unsigned char TM2CNT           @ 0x19;     //{ TM2CNT[7:0] }
extern volatile unsigned char TM2R             @ 0x1A;     //{ TM2R[7:0] }
extern volatile unsigned char TM3CON           @ 0x1B;     //{ T3EN, T3RATE[2:0], T3CKS, T3RSTB, T3OUT, PWM3OUT }
extern volatile unsigned char TM3IN            @ 0x1C;     //{ TM3IN[7:0] }
extern volatile unsigned char TM3CNT           @ 0x1D;     //{ TM3CNT[7:0] }
extern volatile unsigned char TM3R             @ 0x1E;     //{ TM3R[7:0] }
extern volatile unsigned char TM3INH           @ 0x1F;     //{ 0, 0, 0, 0, TM3INH[11:8] }
extern volatile unsigned char PT1              @ 0x20;     //{ 0, 0, PT1[5:3], 0, 0, PT1[0:0] }
extern volatile unsigned char PT1EN            @ 0x21;     //{ 0, 0, PT1EN[5:3], 0, 0, PT1EN[0:0] }
extern volatile unsigned char PT1PU            @ 0x22;     //{ 0, 0, PT1PU[5:3], 0, 0, PT1PU[0:0] }
extern volatile unsigned char PT1CON           @ 0x23;     //{ 0, 0, PT1W[2:0], E1M, E0M[1:0] }
extern volatile unsigned char TM2INH           @ 0x24;     //{ 0, 0, 0, 0, TM2IN[11:8] }
extern volatile unsigned char TM2CNTH          @ 0x25;     //{ 0, 0, 0, 0, TM2CNT[11:8] }
extern volatile unsigned char TM2RH            @ 0x26;     //{ 0, 0, 0, 0, TM2R[11:8] }
extern volatile unsigned char TM3CNTH          @ 0x27;     //{ 0, 0, 0, 0, TM3CNT[11:8] }
extern volatile unsigned char PT3              @ 0x28;     //{ 0, PT3[6:0] }
extern volatile unsigned char PT3EN            @ 0x29;     //{ 0, PT3EN[6:0] }
extern volatile unsigned char PT3PU            @ 0x2A;     //{ 0, PT3PU[6:0] }
extern volatile unsigned char PT3CON           @ 0x2B;     //{ 0, PT3CON[6:0] }
extern volatile unsigned char TM3RH            @ 0x2C;     //{ 0, 0, 0, 0, TM3R[11:8] }
extern volatile unsigned char TM3CON2          @ 0x2D;     //{ DT3CK[1:0], DT3CNT[2:0], DT3_EN, P3H_OEN, P3L_OEN }
extern volatile unsigned char CONFIG1          @ 0x2E;     //{ P3HINV, P3LINV, PWM4STALL, PWM3STALL, PWM2STALL, PWM2PO, 0, 0 }
extern volatile unsigned char CONFIG2          @ 0x2F;     //{ VTHSEL, 0, 0, 0, PWMIS, T3RATE[3:3], T2RATE[3:3], T4RATE[3:3] }
extern volatile unsigned char PT5              @ 0x30;     //{ PT5[7:0] }
extern volatile unsigned char PT5EN            @ 0x31;     //{ PT5EN[7:0] }
extern volatile unsigned char PT5PU            @ 0x32;     //{ PT5U[7:0] }
extern volatile unsigned char PT5CON           @ 0x33;     //{ PT5CON[7:0] }
extern volatile unsigned char SRADCON0         @ 0x34;     //{ 0, SARVCMSEL, SRADACKS[1:0], 0, 0, SRADCKS[1:0] }
extern volatile unsigned char SRADCON1         @ 0x35;     //{ SRADEN, SRADS, OFTEN, CALIF, ENOV, OFFEX, VREFS[1:0] }
extern volatile unsigned char SRADCON2         @ 0x36;     //{ CHS[3:0], 0, 0, 0, SAR_DIFFEN }
extern volatile unsigned char SRADL            @ 0x37;     //{ SRAD[7:0] }
extern volatile unsigned char SRADH            @ 0x38;     //{ 0, 0, 0, 0, SRAD[11:8] }
extern volatile unsigned char SROFTL           @ 0x39;     //{ SROFT[7:0] }
extern volatile unsigned char SROFTH           @ 0x3A;     //{ 0, 0, 0, 0, SROFT[11:8] }
extern volatile unsigned char INTF2            @ 0x3C;     //{ 0, 0, 0, TM3IF, TM4IF, LVDIF, I2CIF, UR0IF }
extern volatile unsigned char INTE2            @ 0x3D;     //{ 0, 0, 0, TM3IE, TM4IE, LVDIE, 0, 0 }
extern volatile unsigned char INTCFG           @ 0x40;     //{ INTCFG[7:0] }
extern volatile unsigned char PT1CON1          @ 0x41;     //{ 0, 0, 0, 0, 0, 0, 0, PT1CON0 }
extern volatile unsigned char PT5CON1          @ 0x42;     //{ PT5W[7:5], 0, 0, 0, 0, 0 }
extern volatile unsigned char TM3CON3          @ 0x45;     //{ PWM3PO, 0, 0, 0, P3H2INV, P3L2INV, P3H2OEN, P3L2OEN }
extern volatile unsigned char WWDTCR           @ 0x47;     //{ WWDTEN, TR[6:0] }
extern volatile unsigned char WWDTWR           @ 0x48;     //{ 0, WD[6:0] }
extern volatile unsigned char UR0_CR1          @ 0x50;     //{ TX9D, RX9D, TX9_EN, RX9_EN, RX_EN, TX_EN, UART0_SEL, UART0_EN }
extern volatile unsigned char UR0_BRR0         @ 0x51;     //{ BRR0[-1:-1] }
extern volatile unsigned char UR0_BRR1         @ 0x52;     //{ 0, UARTDIV[2:0], BRR1[3:0] }
extern volatile unsigned char UR0_TX_REG       @ 0x53;     //{ TX_REG[-1:-1] }
extern volatile unsigned char UR0_RX_REG       @ 0x54;     //{ RX_REG[-1:-1] }
extern volatile unsigned char UR0_ST           @ 0x55;     //{ UR_TINV, UR_RINV, 0, TXFIFO_EMPTY, RX_BUSY, TX_BUSY, RX_OV_ERR, STOP_ERR }
extern volatile unsigned char UR0_INTF         @ 0x56;     //{ 0, 0, 0, UR0ERRIF, UR0_RHIF, UR0_RNIF, UR0WK_IF, UR0_TEIF }
extern volatile unsigned char UR0_INTE         @ 0x57;     //{ 0, 0, 0, UR0ERRIE, UR0_RHIE, UR0_RNIE, UR0WK_IE, UR0_TEIE }
extern volatile unsigned char I2CCON           @ 0x59;     //{ I2C_EN, AWK_EN, CST_EN, ACK_EN, I2CSTUS[3:0] }
extern volatile unsigned char I2CCON1          @ 0x5A;     //{ I2C_SEL, 0, 0, 0, 0, 0, I2C_DIV[1:0] }
extern volatile unsigned char I2CDAT           @ 0x5B;     //{ I2CDAT[7:0] }
extern volatile unsigned char I2CADR           @ 0x5C;     //{ I2CADR[6:0], GC_EN }
extern volatile unsigned char I2C_INTF         @ 0x5D;     //{ I2C_TIF, I2C_RIF, I2C_STIF, 0, 0, 0, 0, 0 }
extern volatile unsigned char I2C_INTE         @ 0x5E;     //{ I2C_TIE, I2C_RIE, I2C_STIE, 0, 0, 0, 0, 0 }
extern volatile unsigned char ISPCON1          @ 0x60;     //{ 0, ISPWDTRF, 0, 0, 0, 0, 0, ISPOF }
extern volatile unsigned char WRPRT            @ 0x63;     //{ 0, 0, 0, 0, 0, 0, 0, WRPRTF }
extern volatile unsigned char TM4CON           @ 0x64;     //{ T4EN, T4RATE[2:0], T4CKS, T4RSTB, T4OUT, PWM4OUT }
extern volatile unsigned char TM4IN            @ 0x65;     //{ TM4IN[7:0] }
extern volatile unsigned char TM4CNT           @ 0x66;     //{ TM4CNT[7:0] }
extern volatile unsigned char TM4R             @ 0x67;     //{ TM4R[7:0] }
extern volatile unsigned char TM4INH           @ 0x68;     //{ 0, 0, 0, 0, TM4IN[11:8] }
extern volatile unsigned char TM4CNTH          @ 0x69;     //{ 0, 0, 0, 0, TM4CNT[11:8] }
extern volatile unsigned char TM4RH            @ 0x6A;     //{ 0, 0, 0, 0, TM4R[11:8] }
extern volatile unsigned char LEDADR           @ 0x6E;     //{ 0, 0, 0, 0, 0, LEDADR[2:0] }
extern volatile unsigned char LEDDAT           @ 0x6F;     //{ LEDDAT[7:0] }
extern volatile unsigned char LEDDUTY          @ 0x70;     //{ 0, 0, 0, LEDDUTY[4:0] }
extern volatile unsigned char LEDCOM           @ 0x71;     //{ LEDCOM[7:0] }
extern volatile unsigned char LEDCON           @ 0x72;     //{ LEDEN, LEDCKS[1:0], LEDAUTO, 0, 0, LEDNUM[1:0] }
extern volatile unsigned char LEDCON1          @ 0x73;     //{ 0, 0, 0, 0, 0, 0, LEDCUR[1:0] }
extern volatile unsigned char CHPCON           @ 0x74;     //{ 0, 0, CHIPCLKSEL[1:0], CHPEN, 0, 0, CHPBYPSS }
extern volatile unsigned char TBLPEN           @ 0x77;     //{ TBLPEN[7:0] }
extern volatile unsigned char LVDCON           @ 0x78;     //{ 0, 0, 0, LVDEN, LVDF, LVD_SEL[2:0] }
extern volatile unsigned char MCK1            @ 0x79;     //{ 0, 0, 0, 0, MCK1[3:0] }
extern volatile unsigned char PT5_BIGDRV       @ 0x7A;     //{ PT5_BIGDRV[7:0] }
extern volatile unsigned char CONFLASH         @ 0x7C;     //{ 0, 0, CONFLASH[5:0] }

//-------------------------------------------------------
//  STATUS register bit map
//-------------------------------------------------------
extern volatile sbit Z                         @ 0x04*8+0;
extern volatile sbit C                         @ 0x04*8+1;
extern volatile sbit DC                        @ 0x04*8+2;
extern volatile sbit TO                        @ 0x04*8+3;
extern volatile sbit PD                        @ 0x04*8+4;

//-------------------------------------------------------
//  INTF register bit map
//-------------------------------------------------------
extern volatile sbit E0IF                      @ 0x06*8+0;
extern volatile sbit E1IF                      @ 0x06*8+1;
extern volatile sbit SRADIF                    @ 0x06*8+3;
extern volatile sbit TM0IF                     @ 0x06*8+4;
extern volatile sbit TM2IF                     @ 0x06*8+6;

//-------------------------------------------------------
//  INTE register bit map
//-------------------------------------------------------
extern volatile sbit E0IE                      @ 0x07*8+0;
extern volatile sbit E1IE                      @ 0x07*8+1;
extern volatile sbit SRADIE                    @ 0x07*8+3;
extern volatile sbit TM0IE                     @ 0x07*8+4;
extern volatile sbit TM2IE                     @ 0x07*8+6;
extern volatile sbit GIE                       @ 0x07*8+7;

//-------------------------------------------------------
//  BSR register bit map
//-------------------------------------------------------
extern volatile sbit PAGE_0                    @ 0x08*8+0;
extern volatile sbit IRP0                      @ 0x08*8+7;

//-------------------------------------------------------
//  RSTSR register bit map
//-------------------------------------------------------
extern volatile sbit WWDTF                     @ 0x09*8+0;
extern volatile sbit ILOPF                     @ 0x09*8+1;
extern volatile sbit EMCF                      @ 0x09*8+2;

//-------------------------------------------------------
//  EADRH register bit map
//-------------------------------------------------------
extern volatile sbit EADR_8                    @ 0x0A*8+0;
extern volatile sbit EADR_9                    @ 0x0A*8+1;
extern volatile sbit EADR_10                   @ 0x0A*8+2;
extern volatile sbit EADR_11                   @ 0x0A*8+3;
extern volatile sbit EADR_12                   @ 0x0A*8+4;
extern volatile sbit EADR_13                   @ 0x0A*8+5;
extern volatile sbit EADR_14                   @ 0x0A*8+6;
extern volatile sbit EADR_15                   @ 0x0A*8+7;

//-------------------------------------------------------
//  EADRL register bit map
//-------------------------------------------------------
extern volatile sbit EADR_0                    @ 0x0B*8+0;
extern volatile sbit EADR_1                    @ 0x0B*8+1;
extern volatile sbit EADR_2                    @ 0x0B*8+2;
extern volatile sbit EADR_3                    @ 0x0B*8+3;
extern volatile sbit EADR_4                    @ 0x0B*8+4;
extern volatile sbit EADR_5                    @ 0x0B*8+5;
extern volatile sbit EADR_6                    @ 0x0B*8+6;
extern volatile sbit EADR_7                    @ 0x0B*8+7;

//-------------------------------------------------------
//  EDATH register bit map
//-------------------------------------------------------
extern volatile sbit EDATH_0                   @ 0x0C*8+0;
extern volatile sbit EDATH_1                   @ 0x0C*8+1;
extern volatile sbit EDATH_2                   @ 0x0C*8+2;
extern volatile sbit EDATH_3                   @ 0x0C*8+3;
extern volatile sbit EDATH_4                   @ 0x0C*8+4;
extern volatile sbit EDATH_5                   @ 0x0C*8+5;
extern volatile sbit EDATH_6                   @ 0x0C*8+6;
extern volatile sbit EDATH_7                   @ 0x0C*8+7;

//-------------------------------------------------------
//  WDTCON register bit map
//-------------------------------------------------------
extern volatile sbit WTS_0                     @ 0x0D*8+0;
extern volatile sbit WTS_1                     @ 0x0D*8+1;
extern volatile sbit WTS_2                     @ 0x0D*8+2;
extern volatile sbit WDTEN                     @ 0x0D*8+7;

//-------------------------------------------------------
//  WDTIN register bit map
//-------------------------------------------------------
extern volatile sbit WDTIN_0                   @ 0x0E*8+0;
extern volatile sbit WDTIN_1                   @ 0x0E*8+1;
extern volatile sbit WDTIN_2                   @ 0x0E*8+2;
extern volatile sbit WDTIN_3                   @ 0x0E*8+3;
extern volatile sbit WDTIN_4                   @ 0x0E*8+4;
extern volatile sbit WDTIN_5                   @ 0x0E*8+5;
extern volatile sbit WDTIN_6                   @ 0x0E*8+6;
extern volatile sbit WDTIN_7                   @ 0x0E*8+7;

//-------------------------------------------------------
//  TM0CON register bit map
//-------------------------------------------------------
extern volatile sbit T0SEL_0                   @ 0x0F*8+0;
extern volatile sbit T0SEL_1                   @ 0x0F*8+1;
extern volatile sbit T0RSTB                    @ 0x0F*8+2;
extern volatile sbit T0RATE_0                  @ 0x0F*8+4;
extern volatile sbit T0RATE_1                  @ 0x0F*8+5;
extern volatile sbit T0RATE_2                  @ 0x0F*8+6;
extern volatile sbit T0EN                      @ 0x0F*8+7;

//-------------------------------------------------------
//  TM0IN register bit map
//-------------------------------------------------------
extern volatile sbit TM0IN_0                   @ 0x10*8+0;
extern volatile sbit TM0IN_1                   @ 0x10*8+1;
extern volatile sbit TM0IN_2                   @ 0x10*8+2;
extern volatile sbit TM0IN_3                   @ 0x10*8+3;
extern volatile sbit TM0IN_4                   @ 0x10*8+4;
extern volatile sbit TM0IN_5                   @ 0x10*8+5;
extern volatile sbit TM0IN_6                   @ 0x10*8+6;
extern volatile sbit TM0IN_7                   @ 0x10*8+7;

//-------------------------------------------------------
//  TM0CNT register bit map
//-------------------------------------------------------
extern volatile sbit TM0CNT_0                  @ 0x11*8+0;
extern volatile sbit TM0CNT_1                  @ 0x11*8+1;
extern volatile sbit TM0CNT_2                  @ 0x11*8+2;
extern volatile sbit TM0CNT_3                  @ 0x11*8+3;
extern volatile sbit TM0CNT_4                  @ 0x11*8+4;
extern volatile sbit TM0CNT_5                  @ 0x11*8+5;
extern volatile sbit TM0CNT_6                  @ 0x11*8+6;
extern volatile sbit TM0CNT_7                  @ 0x11*8+7;

//-------------------------------------------------------
//  PAGECTL register bit map
//-------------------------------------------------------
extern volatile sbit PAGE2                     @ 0x14*8+0;

//-------------------------------------------------------
//  MCK register bit map
//-------------------------------------------------------
extern volatile sbit CST_WDT                   @ 0x16*8+5;

//-------------------------------------------------------
//  TM2CON register bit map
//-------------------------------------------------------
extern volatile sbit PWM2OUT                   @ 0x17*8+0;
extern volatile sbit T2OUT                     @ 0x17*8+1;
extern volatile sbit T2RSTB                    @ 0x17*8+2;
extern volatile sbit T2CKS                     @ 0x17*8+3;
extern volatile sbit T2RATE_0                  @ 0x17*8+4;
extern volatile sbit T2RATE_1                  @ 0x17*8+5;
extern volatile sbit T2RATE_2                  @ 0x17*8+6;
extern volatile sbit T2EN                      @ 0x17*8+7;

//-------------------------------------------------------
//  TM2IN register bit map
//-------------------------------------------------------
extern volatile sbit TM2IN_0                   @ 0x18*8+0;
extern volatile sbit TM2IN_1                   @ 0x18*8+1;
extern volatile sbit TM2IN_2                   @ 0x18*8+2;
extern volatile sbit TM2IN_3                   @ 0x18*8+3;
extern volatile sbit TM2IN_4                   @ 0x18*8+4;
extern volatile sbit TM2IN_5                   @ 0x18*8+5;
extern volatile sbit TM2IN_6                   @ 0x18*8+6;
extern volatile sbit TM2IN_7                   @ 0x18*8+7;

//-------------------------------------------------------
//  TM2CNT register bit map
//-------------------------------------------------------
extern volatile sbit TM2CNT_0                  @ 0x19*8+0;
extern volatile sbit TM2CNT_1                  @ 0x19*8+1;
extern volatile sbit TM2CNT_2                  @ 0x19*8+2;
extern volatile sbit TM2CNT_3                  @ 0x19*8+3;
extern volatile sbit TM2CNT_4                  @ 0x19*8+4;
extern volatile sbit TM2CNT_5                  @ 0x19*8+5;
extern volatile sbit TM2CNT_6                  @ 0x19*8+6;
extern volatile sbit TM2CNT_7                  @ 0x19*8+7;

//-------------------------------------------------------
//  TM2R register bit map
//-------------------------------------------------------
extern volatile sbit TM2R_0                    @ 0x1A*8+0;
extern volatile sbit TM2R_1                    @ 0x1A*8+1;
extern volatile sbit TM2R_2                    @ 0x1A*8+2;
extern volatile sbit TM2R_3                    @ 0x1A*8+3;
extern volatile sbit TM2R_4                    @ 0x1A*8+4;
extern volatile sbit TM2R_5                    @ 0x1A*8+5;
extern volatile sbit TM2R_6                    @ 0x1A*8+6;
extern volatile sbit TM2R_7                    @ 0x1A*8+7;

//-------------------------------------------------------
//  TM3CON register bit map
//-------------------------------------------------------
extern volatile sbit PWM3OUT                   @ 0x1B*8+0;
extern volatile sbit T3OUT                     @ 0x1B*8+1;
extern volatile sbit T3RSTB                    @ 0x1B*8+2;
extern volatile sbit T3CKS                     @ 0x1B*8+3;
extern volatile sbit T3RATE_0                  @ 0x1B*8+4;
extern volatile sbit T3RATE_1                  @ 0x1B*8+5;
extern volatile sbit T3RATE_2                  @ 0x1B*8+6;
extern volatile sbit T3EN                      @ 0x1B*8+7;

//-------------------------------------------------------
//  TM3IN register bit map
//-------------------------------------------------------
extern volatile sbit TM3IN_0                   @ 0x1C*8+0;
extern volatile sbit TM3IN_1                   @ 0x1C*8+1;
extern volatile sbit TM3IN_2                   @ 0x1C*8+2;
extern volatile sbit TM3IN_3                   @ 0x1C*8+3;
extern volatile sbit TM3IN_4                   @ 0x1C*8+4;
extern volatile sbit TM3IN_5                   @ 0x1C*8+5;
extern volatile sbit TM3IN_6                   @ 0x1C*8+6;
extern volatile sbit TM3IN_7                   @ 0x1C*8+7;

//-------------------------------------------------------
//  TM3CNT register bit map
//-------------------------------------------------------
extern volatile sbit TM3CNT_0                  @ 0x1D*8+0;
extern volatile sbit TM3CNT_1                  @ 0x1D*8+1;
extern volatile sbit TM3CNT_2                  @ 0x1D*8+2;
extern volatile sbit TM3CNT_3                  @ 0x1D*8+3;
extern volatile sbit TM3CNT_4                  @ 0x1D*8+4;
extern volatile sbit TM3CNT_5                  @ 0x1D*8+5;
extern volatile sbit TM3CNT_6                  @ 0x1D*8+6;
extern volatile sbit TM3CNT_7                  @ 0x1D*8+7;

//-------------------------------------------------------
//  TM3R register bit map
//-------------------------------------------------------
extern volatile sbit TM3R_0                    @ 0x1E*8+0;
extern volatile sbit TM3R_1                    @ 0x1E*8+1;
extern volatile sbit TM3R_2                    @ 0x1E*8+2;
extern volatile sbit TM3R_3                    @ 0x1E*8+3;
extern volatile sbit TM3R_4                    @ 0x1E*8+4;
extern volatile sbit TM3R_5                    @ 0x1E*8+5;
extern volatile sbit TM3R_6                    @ 0x1E*8+6;
extern volatile sbit TM3R_7                    @ 0x1E*8+7;

//-------------------------------------------------------
//  TM3INH register bit map
//-------------------------------------------------------
extern volatile sbit TM3INH_8                  @ 0x1F*8+0;
extern volatile sbit TM3INH_9                  @ 0x1F*8+1;
extern volatile sbit TM3INH_10                 @ 0x1F*8+2;
extern volatile sbit TM3INH_11                 @ 0x1F*8+3;

//-------------------------------------------------------
//  PT1 register bit map
//-------------------------------------------------------
extern volatile sbit PT1_0                     @ 0x20*8+0;
extern volatile sbit PT1_3                     @ 0x20*8+3;
extern volatile sbit PT1_4                     @ 0x20*8+4;
extern volatile sbit PT1_5                     @ 0x20*8+5;

//-------------------------------------------------------
//  PT1EN register bit map
//-------------------------------------------------------
extern volatile sbit PT1EN_0                    @ 0x21*8+0;
extern volatile sbit PT1EN_3                    @ 0x21*8+3;
extern volatile sbit PT1EN_4                    @ 0x21*8+4;
extern volatile sbit PT1EN_5                    @ 0x21*8+5;

//-------------------------------------------------------
//  PT1PU register bit map
//-------------------------------------------------------
extern volatile sbit PT1PU_0                   @ 0x22*8+0;
extern volatile sbit PT1PU_3                   @ 0x22*8+3;
extern volatile sbit PT1PU_4                   @ 0x22*8+4;
extern volatile sbit PT1PU_5                   @ 0x22*8+5;

//-------------------------------------------------------
//  PT1CON register bit map
//-------------------------------------------------------
extern volatile sbit E0M_0                     @ 0x23*8+0;
extern volatile sbit E0M_1                     @ 0x23*8+1;
extern volatile sbit E1M                       @ 0x23*8+2;
extern volatile sbit PT1W_0                    @ 0x23*8+3;
extern volatile sbit PT1W_1                    @ 0x23*8+4;
extern volatile sbit PT1W_2                    @ 0x23*8+5;

//-------------------------------------------------------
//  TM2INH register bit map
//-------------------------------------------------------
extern volatile sbit TM2IN_8                   @ 0x24*8+0;
extern volatile sbit TM2IN_9                   @ 0x24*8+1;
extern volatile sbit TM2IN_10                  @ 0x24*8+2;
extern volatile sbit TM2IN_11                  @ 0x24*8+3;

//-------------------------------------------------------
//  TM2CNTH register bit map
//-------------------------------------------------------
extern volatile sbit TM2CNT_8                  @ 0x25*8+0;
extern volatile sbit TM2CNT_9                  @ 0x25*8+1;
extern volatile sbit TM2CNT_10                 @ 0x25*8+2;
extern volatile sbit TM2CNT_11                 @ 0x25*8+3;

//-------------------------------------------------------
//  TM2RH register bit map
//-------------------------------------------------------
extern volatile sbit TM2R_8                    @ 0x26*8+0;
extern volatile sbit TM2R_9                    @ 0x26*8+1;
extern volatile sbit TM2R_10                   @ 0x26*8+2;
extern volatile sbit TM2R_11                   @ 0x26*8+3;

//-------------------------------------------------------
//  TM3CNTH register bit map
//-------------------------------------------------------
extern volatile sbit TM3CNT_8                  @ 0x27*8+0;
extern volatile sbit TM3CNT_9                  @ 0x27*8+1;
extern volatile sbit TM3CNT_10                 @ 0x27*8+2;
extern volatile sbit TM3CNT_11                 @ 0x27*8+3;

//-------------------------------------------------------
//  PT3 register bit map
//-------------------------------------------------------
extern volatile sbit PT3_0                     @ 0x28*8+0;
extern volatile sbit PT3_1                     @ 0x28*8+1;
extern volatile sbit PT3_2                     @ 0x28*8+2;
extern volatile sbit PT3_3                     @ 0x28*8+3;
extern volatile sbit PT3_4                     @ 0x28*8+4;
extern volatile sbit PT3_5                     @ 0x28*8+5;
extern volatile sbit PT3_6                     @ 0x28*8+6;

//-------------------------------------------------------
//  PT3EN register bit map
//-------------------------------------------------------
extern volatile sbit PT3EN_0                   @ 0x29*8+0;
extern volatile sbit PT3EN_1                   @ 0x29*8+1;
extern volatile sbit PT3EN_2                   @ 0x29*8+2;
extern volatile sbit PT3EN_3                   @ 0x29*8+3;
extern volatile sbit PT3EN_4                   @ 0x29*8+4;
extern volatile sbit PT3EN_5                   @ 0x29*8+5;
extern volatile sbit PT3EN_6                   @ 0x29*8+6;

//-------------------------------------------------------
//  PT3PU register bit map
//-------------------------------------------------------
extern volatile sbit PT3PU_0                   @ 0x2A*8+0;
extern volatile sbit PT3PU_1                   @ 0x2A*8+1;
extern volatile sbit PT3PU_2                   @ 0x2A*8+2;
extern volatile sbit PT3PU_3                   @ 0x2A*8+3;
extern volatile sbit PT3PU_4                   @ 0x2A*8+4;
extern volatile sbit PT3PU_5                   @ 0x2A*8+5;
extern volatile sbit PT3PU_6                   @ 0x2A*8+6;

//-------------------------------------------------------
//  PT3CON register bit map
//-------------------------------------------------------
extern volatile sbit PT3CON_0                  @ 0x2B*8+0;
extern volatile sbit PT3CON_1                  @ 0x2B*8+1;
extern volatile sbit PT3CON_2                  @ 0x2B*8+2;
extern volatile sbit PT3CON_3                  @ 0x2B*8+3;
extern volatile sbit PT3CON_4                  @ 0x2B*8+4;
extern volatile sbit PT3CON_5                  @ 0x2B*8+5;
extern volatile sbit PT3CON_6                  @ 0x2B*8+6;

//-------------------------------------------------------
//  TM3RH register bit map
//-------------------------------------------------------
extern volatile sbit TM3R_8                    @ 0x2C*8+0;
extern volatile sbit TM3R_9                    @ 0x2C*8+1;
extern volatile sbit TM3R_10                   @ 0x2C*8+2;
extern volatile sbit TM3R_11                   @ 0x2C*8+3;

//-------------------------------------------------------
//  TM3CON2 register bit map
//-------------------------------------------------------
extern volatile sbit P3L_OEN                   @ 0x2D*8+0;
extern volatile sbit P3H_OEN                   @ 0x2D*8+1;
extern volatile sbit DT3_EN                    @ 0x2D*8+2;
extern volatile sbit DT3CNT_0                  @ 0x2D*8+3;
extern volatile sbit DT3CNT_1                  @ 0x2D*8+4;
extern volatile sbit DT3CNT_2                  @ 0x2D*8+5;
extern volatile sbit DT3CK_0                   @ 0x2D*8+6;
extern volatile sbit DT3CK_1                   @ 0x2D*8+7;

//-------------------------------------------------------
//  CONFIG1 register bit map
//-------------------------------------------------------
extern volatile sbit PWM2PO                    @ 0x2E*8+2;
extern volatile sbit PWM2STALL                 @ 0x2E*8+3;
extern volatile sbit PWM3STALL                 @ 0x2E*8+4;
extern volatile sbit PWM4STALL                 @ 0x2E*8+5;
extern volatile sbit P3LINV                    @ 0x2E*8+6;
extern volatile sbit P3HINV                    @ 0x2E*8+7;

//-------------------------------------------------------
//  CONFIG2 register bit map
//-------------------------------------------------------
extern volatile sbit T4RATE_3                  @ 0x2F*8+0;
extern volatile sbit T2RATE_3                  @ 0x2F*8+1;
extern volatile sbit T3RATE_3                  @ 0x2F*8+2;
extern volatile sbit PWMIS                     @ 0x2F*8+3;
extern volatile sbit VTHSEL                    @ 0x2F*8+7;

//-------------------------------------------------------
//  PT5 register bit map
//-------------------------------------------------------
extern volatile sbit PT5_0                     @ 0x30*8+0;
extern volatile sbit PT5_1                     @ 0x30*8+1;
extern volatile sbit PT5_2                     @ 0x30*8+2;
extern volatile sbit PT5_3                     @ 0x30*8+3;
extern volatile sbit PT5_4                     @ 0x30*8+4;
extern volatile sbit PT5_5                     @ 0x30*8+5;
extern volatile sbit PT5_6                     @ 0x30*8+6;
extern volatile sbit PT5_7                     @ 0x30*8+7;

//-------------------------------------------------------
//  PT5EN register bit map
//-------------------------------------------------------
extern volatile sbit PT5EN_0                   @ 0x31*8+0;
extern volatile sbit PT5EN_1                   @ 0x31*8+1;
extern volatile sbit PT5EN_2                   @ 0x31*8+2;
extern volatile sbit PT5EN_3                   @ 0x31*8+3;
extern volatile sbit PT5EN_4                   @ 0x31*8+4;
extern volatile sbit PT5EN_5                   @ 0x31*8+5;
extern volatile sbit PT5EN_6                   @ 0x31*8+6;
extern volatile sbit PT5EN_7                   @ 0x31*8+7;

//-------------------------------------------------------
//  PT5PU register bit map
//-------------------------------------------------------
extern volatile sbit PT5PU_0                   @ 0x32*8+0;
extern volatile sbit PT5PU_1                   @ 0x32*8+1;
extern volatile sbit PT5PU_2                   @ 0x32*8+2;
extern volatile sbit PT5PU_3                   @ 0x32*8+3;
extern volatile sbit PT5PU_4                   @ 0x32*8+4;
extern volatile sbit PT5PU_5                   @ 0x32*8+5;
extern volatile sbit PT5PU_6                   @ 0x32*8+6;
extern volatile sbit PT5PU_7                   @ 0x32*8+7;

//-------------------------------------------------------
//  PT5CON register bit map
//-------------------------------------------------------
extern volatile sbit PT5CON_0                  @ 0x33*8+0;
extern volatile sbit PT5CON_1                  @ 0x33*8+1;
extern volatile sbit PT5CON_2                  @ 0x33*8+2;
extern volatile sbit PT5CON_3                  @ 0x33*8+3;
extern volatile sbit PT5CON_4                  @ 0x33*8+4;
extern volatile sbit PT5CON_5                  @ 0x33*8+5;
extern volatile sbit PT5CON_6                  @ 0x33*8+6;
extern volatile sbit PT5CON_7                  @ 0x33*8+7;

//-------------------------------------------------------
//  SRADCON0 register bit map
//-------------------------------------------------------
extern volatile sbit SRADCKS_0                 @ 0x34*8+0;
extern volatile sbit SRADCKS_1                 @ 0x34*8+1;
extern volatile sbit SRADACKS_0                @ 0x34*8+4;
extern volatile sbit SRADACKS_1                @ 0x34*8+5;
extern volatile sbit SARVCMSEL                 @ 0x34*8+6;

//-------------------------------------------------------
//  SRADCON1 register bit map
//-------------------------------------------------------
extern volatile sbit VREFS_0                   @ 0x35*8+0;
extern volatile sbit VREFS_1                   @ 0x35*8+1;
extern volatile sbit OFFEX                     @ 0x35*8+2;
extern volatile sbit ENOV                      @ 0x35*8+3;
extern volatile sbit CALIF                     @ 0x35*8+4;
extern volatile sbit OFTEN                     @ 0x35*8+5;
extern volatile sbit SRADS                     @ 0x35*8+6;
extern volatile sbit SRADEN                    @ 0x35*8+7;

//-------------------------------------------------------
//  SRADCON2 register bit map
//-------------------------------------------------------
extern volatile sbit SAR_DIFFEN                @ 0x36*8+0;
extern volatile sbit CHS_0                     @ 0x36*8+4;
extern volatile sbit CHS_1                     @ 0x36*8+5;
extern volatile sbit CHS_2                     @ 0x36*8+6;
extern volatile sbit CHS_3                     @ 0x36*8+7;

//-------------------------------------------------------
//  SRADL register bit map
//-------------------------------------------------------
extern volatile sbit SRAD_0                    @ 0x37*8+0;
extern volatile sbit SRAD_1                    @ 0x37*8+1;
extern volatile sbit SRAD_2                    @ 0x37*8+2;
extern volatile sbit SRAD_3                    @ 0x37*8+3;
extern volatile sbit SRAD_4                    @ 0x37*8+4;
extern volatile sbit SRAD_5                    @ 0x37*8+5;
extern volatile sbit SRAD_6                    @ 0x37*8+6;
extern volatile sbit SRAD_7                    @ 0x37*8+7;

//-------------------------------------------------------
//  SRADH register bit map
//-------------------------------------------------------
extern volatile sbit SRAD_8                    @ 0x38*8+0;
extern volatile sbit SRAD_9                    @ 0x38*8+1;
extern volatile sbit SRAD_10                   @ 0x38*8+2;
extern volatile sbit SRAD_11                   @ 0x38*8+3;

//-------------------------------------------------------
//  SROFTL register bit map
//-------------------------------------------------------
extern volatile sbit SROFT_0                   @ 0x39*8+0;
extern volatile sbit SROFT_1                   @ 0x39*8+1;
extern volatile sbit SROFT_2                   @ 0x39*8+2;
extern volatile sbit SROFT_3                   @ 0x39*8+3;
extern volatile sbit SROFT_4                   @ 0x39*8+4;
extern volatile sbit SROFT_5                   @ 0x39*8+5;
extern volatile sbit SROFT_6                   @ 0x39*8+6;
extern volatile sbit SROFT_7                   @ 0x39*8+7;

//-------------------------------------------------------
//  SROFTH register bit map
//-------------------------------------------------------
extern volatile sbit SROFT_8                   @ 0x3A*8+0;
extern volatile sbit SROFT_9                   @ 0x3A*8+1;
extern volatile sbit SROFT_10                  @ 0x3A*8+2;
extern volatile sbit SROFT_11                  @ 0x3A*8+3;

//-------------------------------------------------------
//  INTF2 register bit map
//-------------------------------------------------------
extern volatile sbit UR0IF                     @ 0x3C*8+0;
extern volatile sbit I2CIF                     @ 0x3C*8+1;
extern volatile sbit LVDIF                     @ 0x3C*8+2;
extern volatile sbit TM4IF                     @ 0x3C*8+3;
extern volatile sbit TM3IF                     @ 0x3C*8+4;

//-------------------------------------------------------
//  INTE2 register bit map
//-------------------------------------------------------
extern volatile sbit LVDIE                     @ 0x3D*8+2;
extern volatile sbit TM4IE                     @ 0x3D*8+3;
extern volatile sbit TM3IE                     @ 0x3D*8+4;

//-------------------------------------------------------
//  INTCFG register bit map
//-------------------------------------------------------
extern volatile sbit INTCFG_0                  @ 0x40*8+0;
extern volatile sbit INTCFG_1                  @ 0x40*8+1;
extern volatile sbit INTCFG_2                  @ 0x40*8+2;
extern volatile sbit INTCFG_3                  @ 0x40*8+3;
extern volatile sbit INTCFG_4                  @ 0x40*8+4;
extern volatile sbit INTCFG_5                  @ 0x40*8+5;
extern volatile sbit INTCFG_6                  @ 0x40*8+6;
extern volatile sbit INTCFG_7                  @ 0x40*8+7;

//-------------------------------------------------------
//  PT1CON1 register bit map
//-------------------------------------------------------
extern volatile sbit PT1CON0                   @ 0x41*8+0;

//-------------------------------------------------------
//  PT5CON1 register bit map
//-------------------------------------------------------
extern volatile sbit PT5W_5                    @ 0x42*8+5;
extern volatile sbit PT5W_6                    @ 0x42*8+6;
extern volatile sbit PT5W_7                    @ 0x42*8+7;

//-------------------------------------------------------
//  TM3CON3 register bit map
//-------------------------------------------------------
extern volatile sbit P3L2OEN                   @ 0x45*8+0;
extern volatile sbit P3H2OEN                   @ 0x45*8+1;
extern volatile sbit P3L2INV                   @ 0x45*8+2;
extern volatile sbit P3H2INV                   @ 0x45*8+3;
extern volatile sbit PWM3PO                    @ 0x45*8+7;

//-------------------------------------------------------
//  WWDTCR register bit map
//-------------------------------------------------------
extern volatile sbit TR_0                      @ 0x47*8+0;
extern volatile sbit TR_1                      @ 0x47*8+1;
extern volatile sbit TR_2                      @ 0x47*8+2;
extern volatile sbit TR_3                      @ 0x47*8+3;
extern volatile sbit TR_4                      @ 0x47*8+4;
extern volatile sbit TR_5                      @ 0x47*8+5;
extern volatile sbit TR_6                      @ 0x47*8+6;
extern volatile sbit WWDTEN                    @ 0x47*8+7;

//-------------------------------------------------------
//  WWDTWR register bit map
//-------------------------------------------------------
extern volatile sbit WD_0                      @ 0x48*8+0;
extern volatile sbit WD_1                      @ 0x48*8+1;
extern volatile sbit WD_2                      @ 0x48*8+2;
extern volatile sbit WD_3                      @ 0x48*8+3;
extern volatile sbit WD_4                      @ 0x48*8+4;
extern volatile sbit WD_5                      @ 0x48*8+5;
extern volatile sbit WD_6                      @ 0x48*8+6;

//-------------------------------------------------------
//  UR0_CR1 register bit map
//-------------------------------------------------------
extern volatile sbit UART0_EN                  @ 0x50*8+0;
extern volatile sbit UART0_SEL                 @ 0x50*8+1;
extern volatile sbit TX_EN                     @ 0x50*8+2;
extern volatile sbit RX_EN                     @ 0x50*8+3;
extern volatile sbit RX9_EN                    @ 0x50*8+4;
extern volatile sbit TX9_EN                    @ 0x50*8+5;
extern volatile sbit RX9D                      @ 0x50*8+6;
extern volatile sbit TX9D                      @ 0x50*8+7;

//-------------------------------------------------------
//  UR0_BRR0 register bit map
//-------------------------------------------------------
extern volatile sbit BRR0_0                    @ 0x51*8+0;
extern volatile sbit BRR0_1                    @ 0x51*8+1;
extern volatile sbit BRR0_2                    @ 0x51*8+2;
extern volatile sbit BRR0_3                    @ 0x51*8+3;
extern volatile sbit BRR0_4                    @ 0x51*8+4;
extern volatile sbit BRR0_5                    @ 0x51*8+5;
extern volatile sbit BRR0_6                    @ 0x51*8+6;
extern volatile sbit BRR0_7                    @ 0x51*8+7;

//-------------------------------------------------------
//  UR0_BRR1 register bit map
//-------------------------------------------------------
extern volatile sbit BRR1_0                    @ 0x52*8+0;
extern volatile sbit BRR1_1                    @ 0x52*8+1;
extern volatile sbit BRR1_2                    @ 0x52*8+2;
extern volatile sbit BRR1_3                    @ 0x52*8+3;
extern volatile sbit UARTDIV_0                 @ 0x52*8+4;
extern volatile sbit UARTDIV_1                 @ 0x52*8+5;
extern volatile sbit UARTDIV_2                 @ 0x52*8+6;

//-------------------------------------------------------
//  UR0_TX_REG register bit map
//-------------------------------------------------------
extern volatile sbit TX_REG_0                  @ 0x53*8+0;
extern volatile sbit TX_REG_1                  @ 0x53*8+1;
extern volatile sbit TX_REG_2                  @ 0x53*8+2;
extern volatile sbit TX_REG_3                  @ 0x53*8+3;
extern volatile sbit TX_REG_4                  @ 0x53*8+4;
extern volatile sbit TX_REG_5                  @ 0x53*8+5;
extern volatile sbit TX_REG_6                  @ 0x53*8+6;
extern volatile sbit TX_REG_7                  @ 0x53*8+7;

//-------------------------------------------------------
//  UR0_RX_REG register bit map
//-------------------------------------------------------
extern volatile sbit RX_REG_0                  @ 0x54*8+0;
extern volatile sbit RX_REG_1                  @ 0x54*8+1;
extern volatile sbit RX_REG_2                  @ 0x54*8+2;
extern volatile sbit RX_REG_3                  @ 0x54*8+3;
extern volatile sbit RX_REG_4                  @ 0x54*8+4;
extern volatile sbit RX_REG_5                  @ 0x54*8+5;
extern volatile sbit RX_REG_6                  @ 0x54*8+6;
extern volatile sbit RX_REG_7                  @ 0x54*8+7;

//-------------------------------------------------------
//  UR0_ST register bit map
//-------------------------------------------------------
extern volatile sbit STOP_ERR                  @ 0x55*8+0;
extern volatile sbit RX_OV_ERR                 @ 0x55*8+1;
extern volatile sbit TX_BUSY                   @ 0x55*8+2;
extern volatile sbit RX_BUSY                   @ 0x55*8+3;
extern volatile sbit TXFIFO_EMPTY                @ 0x55*8+4;
extern volatile sbit UR_RINV                   @ 0x55*8+6;
extern volatile sbit UR_TINV                   @ 0x55*8+7;

//-------------------------------------------------------
//  UR0_INTF register bit map
//-------------------------------------------------------
extern volatile sbit UR0_TEIF                  @ 0x56*8+0;
extern volatile sbit UR0WK_IF                  @ 0x56*8+1;
extern volatile sbit UR0_RNIF                  @ 0x56*8+2;
extern volatile sbit UR0_RHIF                  @ 0x56*8+3;
extern volatile sbit UR0ERRIF                  @ 0x56*8+4;

//-------------------------------------------------------
//  UR0_INTE register bit map
//-------------------------------------------------------
extern volatile sbit UR0_TEIE                  @ 0x57*8+0;
extern volatile sbit UR0WK_IE                  @ 0x57*8+1;
extern volatile sbit UR0_RNIE                  @ 0x57*8+2;
extern volatile sbit UR0_RHIE                  @ 0x57*8+3;
extern volatile sbit UR0ERRIE                  @ 0x57*8+4;

//-------------------------------------------------------
//  I2CCON register bit map
//-------------------------------------------------------
extern volatile sbit I2CSTUS_0                 @ 0x59*8+0;
extern volatile sbit I2CSTUS_1                 @ 0x59*8+1;
extern volatile sbit I2CSTUS_2                 @ 0x59*8+2;
extern volatile sbit I2CSTUS_3                 @ 0x59*8+3;
extern volatile sbit ACK_EN                    @ 0x59*8+4;
extern volatile sbit CST_EN                    @ 0x59*8+5;
extern volatile sbit AWK_EN                    @ 0x59*8+6;
extern volatile sbit I2C_EN                    @ 0x59*8+7;

//-------------------------------------------------------
//  I2CCON1 register bit map
//-------------------------------------------------------
extern volatile sbit I2C_DIV_0                 @ 0x5A*8+0;
extern volatile sbit I2C_DIV_1                 @ 0x5A*8+1;
extern volatile sbit I2C_SEL                   @ 0x5A*8+7;

//-------------------------------------------------------
//  I2CDAT register bit map
//-------------------------------------------------------
extern volatile sbit I2CDAT_0                  @ 0x5B*8+0;
extern volatile sbit I2CDAT_1                  @ 0x5B*8+1;
extern volatile sbit I2CDAT_2                  @ 0x5B*8+2;
extern volatile sbit I2CDAT_3                  @ 0x5B*8+3;
extern volatile sbit I2CDAT_4                  @ 0x5B*8+4;
extern volatile sbit I2CDAT_5                  @ 0x5B*8+5;
extern volatile sbit I2CDAT_6                  @ 0x5B*8+6;
extern volatile sbit I2CDAT_7                  @ 0x5B*8+7;

//-------------------------------------------------------
//  I2CADR register bit map
//-------------------------------------------------------
extern volatile sbit GC_EN                     @ 0x5C*8+0;
extern volatile sbit I2CADR_0                  @ 0x5C*8+1;
extern volatile sbit I2CADR_1                  @ 0x5C*8+2;
extern volatile sbit I2CADR_2                  @ 0x5C*8+3;
extern volatile sbit I2CADR_3                  @ 0x5C*8+4;
extern volatile sbit I2CADR_4                  @ 0x5C*8+5;
extern volatile sbit I2CADR_5                  @ 0x5C*8+6;
extern volatile sbit I2CADR_6                  @ 0x5C*8+7;

//-------------------------------------------------------
//  I2C_INTF register bit map
//-------------------------------------------------------
extern volatile sbit I2C_STIF                  @ 0x5D*8+5;
extern volatile sbit I2C_RIF                   @ 0x5D*8+6;
extern volatile sbit I2C_TIF                   @ 0x5D*8+7;

//-------------------------------------------------------
//  I2C_INTE register bit map
//-------------------------------------------------------
extern volatile sbit I2C_STIE                  @ 0x5E*8+5;
extern volatile sbit I2C_RIE                   @ 0x5E*8+6;
extern volatile sbit I2C_TIE                   @ 0x5E*8+7;

//-------------------------------------------------------
//  ISPCON1 register bit map
//-------------------------------------------------------
extern volatile sbit ISPOF                     @ 0x60*8+0;
extern volatile sbit ISPWDTRF                  @ 0x60*8+6;

//-------------------------------------------------------
//  WRPRT register bit map
//-------------------------------------------------------
extern volatile sbit WRPRTF                    @ 0x63*8+0;

//-------------------------------------------------------
//  TM4CON register bit map
//-------------------------------------------------------
extern volatile sbit PWM4OUT                   @ 0x64*8+0;
extern volatile sbit T4OUT                     @ 0x64*8+1;
extern volatile sbit T4RSTB                    @ 0x64*8+2;
extern volatile sbit T4CKS                     @ 0x64*8+3;
extern volatile sbit T4RATE_0                  @ 0x64*8+4;
extern volatile sbit T4RATE_1                  @ 0x64*8+5;
extern volatile sbit T4RATE_2                  @ 0x64*8+6;
extern volatile sbit T4EN                      @ 0x64*8+7;

//-------------------------------------------------------
//  TM4IN register bit map
//-------------------------------------------------------
extern volatile sbit TM4IN_0                   @ 0x65*8+0;
extern volatile sbit TM4IN_1                   @ 0x65*8+1;
extern volatile sbit TM4IN_2                   @ 0x65*8+2;
extern volatile sbit TM4IN_3                   @ 0x65*8+3;
extern volatile sbit TM4IN_4                   @ 0x65*8+4;
extern volatile sbit TM4IN_5                   @ 0x65*8+5;
extern volatile sbit TM4IN_6                   @ 0x65*8+6;
extern volatile sbit TM4IN_7                   @ 0x65*8+7;

//-------------------------------------------------------
//  TM4CNT register bit map
//-------------------------------------------------------
extern volatile sbit TM4CNT_0                  @ 0x66*8+0;
extern volatile sbit TM4CNT_1                  @ 0x66*8+1;
extern volatile sbit TM4CNT_2                  @ 0x66*8+2;
extern volatile sbit TM4CNT_3                  @ 0x66*8+3;
extern volatile sbit TM4CNT_4                  @ 0x66*8+4;
extern volatile sbit TM4CNT_5                  @ 0x66*8+5;
extern volatile sbit TM4CNT_6                  @ 0x66*8+6;
extern volatile sbit TM4CNT_7                  @ 0x66*8+7;

//-------------------------------------------------------
//  TM4R register bit map
//-------------------------------------------------------
extern volatile sbit TM4R_0                    @ 0x67*8+0;
extern volatile sbit TM4R_1                    @ 0x67*8+1;
extern volatile sbit TM4R_2                    @ 0x67*8+2;
extern volatile sbit TM4R_3                    @ 0x67*8+3;
extern volatile sbit TM4R_4                    @ 0x67*8+4;
extern volatile sbit TM4R_5                    @ 0x67*8+5;
extern volatile sbit TM4R_6                    @ 0x67*8+6;
extern volatile sbit TM4R_7                    @ 0x67*8+7;

//-------------------------------------------------------
//  TM4INH register bit map
//-------------------------------------------------------
extern volatile sbit TM4IN_8                   @ 0x68*8+0;
extern volatile sbit TM4IN_9                   @ 0x68*8+1;
extern volatile sbit TM4IN_10                  @ 0x68*8+2;
extern volatile sbit TM4IN_11                  @ 0x68*8+3;

//-------------------------------------------------------
//  TM4CNTH register bit map
//-------------------------------------------------------
extern volatile sbit TM4CNT_8                  @ 0x69*8+0;
extern volatile sbit TM4CNT_9                  @ 0x69*8+1;
extern volatile sbit TM4CNT_10                 @ 0x69*8+2;
extern volatile sbit TM4CNT_11                 @ 0x69*8+3;

//-------------------------------------------------------
//  TM4RH register bit map
//-------------------------------------------------------
extern volatile sbit TM4R_8                    @ 0x6A*8+0;
extern volatile sbit TM4R_9                    @ 0x6A*8+1;
extern volatile sbit TM4R_10                   @ 0x6A*8+2;
extern volatile sbit TM4R_11                   @ 0x6A*8+3;

//-------------------------------------------------------
//  LEDADR register bit map
//-------------------------------------------------------
extern volatile sbit LEDADR_0                  @ 0x6E*8+0;
extern volatile sbit LEDADR_1                  @ 0x6E*8+1;
extern volatile sbit LEDADR_2                  @ 0x6E*8+2;

//-------------------------------------------------------
//  LEDDAT register bit map
//-------------------------------------------------------
extern volatile sbit LEDDAT_0                  @ 0x6F*8+0;
extern volatile sbit LEDDAT_1                  @ 0x6F*8+1;
extern volatile sbit LEDDAT_2                  @ 0x6F*8+2;
extern volatile sbit LEDDAT_3                  @ 0x6F*8+3;
extern volatile sbit LEDDAT_4                  @ 0x6F*8+4;
extern volatile sbit LEDDAT_5                  @ 0x6F*8+5;
extern volatile sbit LEDDAT_6                  @ 0x6F*8+6;
extern volatile sbit LEDDAT_7                  @ 0x6F*8+7;

//-------------------------------------------------------
//  LEDDUTY register bit map
//-------------------------------------------------------
extern volatile sbit LEDDUTY_0                 @ 0x70*8+0;
extern volatile sbit LEDDUTY_1                 @ 0x70*8+1;
extern volatile sbit LEDDUTY_2                 @ 0x70*8+2;
extern volatile sbit LEDDUTY_3                 @ 0x70*8+3;
extern volatile sbit LEDDUTY_4                 @ 0x70*8+4;

//-------------------------------------------------------
//  LEDCOM register bit map
//-------------------------------------------------------
extern volatile sbit LEDCOM_0                  @ 0x71*8+0;
extern volatile sbit LEDCOM_1                  @ 0x71*8+1;
extern volatile sbit LEDCOM_2                  @ 0x71*8+2;
extern volatile sbit LEDCOM_3                  @ 0x71*8+3;
extern volatile sbit LEDCOM_4                  @ 0x71*8+4;
extern volatile sbit LEDCOM_5                  @ 0x71*8+5;
extern volatile sbit LEDCOM_6                  @ 0x71*8+6;
extern volatile sbit LEDCOM_7                  @ 0x71*8+7;

//-------------------------------------------------------
//  LEDCON register bit map
//-------------------------------------------------------
extern volatile sbit LEDNUM_0                  @ 0x72*8+0;
extern volatile sbit LEDNUM_1                  @ 0x72*8+1;
extern volatile sbit LEDAUTO                   @ 0x72*8+4;
extern volatile sbit LEDCKS_0                  @ 0x72*8+5;
extern volatile sbit LEDCKS_1                  @ 0x72*8+6;
extern volatile sbit LEDEN                     @ 0x72*8+7;

//-------------------------------------------------------
//  LEDCON1 register bit map
//-------------------------------------------------------
extern volatile sbit LEDCUR_0                  @ 0x73*8+0;
extern volatile sbit LEDCUR_1                  @ 0x73*8+1;

//-------------------------------------------------------
//  CHPCON register bit map
//-------------------------------------------------------
extern volatile sbit CHPBYPSS                  @ 0x74*8+0;
extern volatile sbit CHPEN                     @ 0x74*8+3;
extern volatile sbit CHIPCLKSEL_0                @ 0x74*8+4;
extern volatile sbit CHIPCLKSEL_1                @ 0x74*8+5;

//-------------------------------------------------------
//  TBLPEN register bit map
//-------------------------------------------------------
extern volatile sbit TBLPEN_0                  @ 0x77*8+0;
extern volatile sbit TBLPEN_1                  @ 0x77*8+1;
extern volatile sbit TBLPEN_2                  @ 0x77*8+2;
extern volatile sbit TBLPEN_3                  @ 0x77*8+3;
extern volatile sbit TBLPEN_4                  @ 0x77*8+4;
extern volatile sbit TBLPEN_5                  @ 0x77*8+5;
extern volatile sbit TBLPEN_6                  @ 0x77*8+6;
extern volatile sbit TBLPEN_7                  @ 0x77*8+7;

//-------------------------------------------------------
//  LVDCON register bit map
//-------------------------------------------------------
extern volatile sbit LVD_SEL_0                 @ 0x78*8+0;
extern volatile sbit LVD_SEL_1                 @ 0x78*8+1;
extern volatile sbit LVD_SEL_2                 @ 0x78*8+2;
extern volatile sbit LVDF                      @ 0x78*8+3;
extern volatile sbit LVDEN                     @ 0x78*8+4;

//-------------------------------------------------------
//  MCK1 register bit map
//-------------------------------------------------------
extern volatile sbit MCK1_0                   @ 0x79*8+0;
extern volatile sbit MCK1_1                   @ 0x79*8+1;
extern volatile sbit MCK1_2                   @ 0x79*8+2;
extern volatile sbit MCK1_3                   @ 0x79*8+3;

//-------------------------------------------------------
//  PT5_BIGDRV register bit map
//-------------------------------------------------------
extern volatile sbit PT5_BIGDRV_0                @ 0x7A*8+0;
extern volatile sbit PT5_BIGDRV_1                @ 0x7A*8+1;
extern volatile sbit PT5_BIGDRV_2                @ 0x7A*8+2;
extern volatile sbit PT5_BIGDRV_3                @ 0x7A*8+3;
extern volatile sbit PT5_BIGDRV_4                @ 0x7A*8+4;
extern volatile sbit PT5_BIGDRV_5                @ 0x7A*8+5;
extern volatile sbit PT5_BIGDRV_6                @ 0x7A*8+6;
extern volatile sbit PT5_BIGDRV_7                @ 0x7A*8+7;

//-------------------------------------------------------
//  CONFLASH register bit map
//-------------------------------------------------------
extern volatile sbit CONFLASH_0                @ 0x7C*8+0;
extern volatile sbit CONFLASH_1                @ 0x7C*8+1;
extern volatile sbit CONFLASH_2                @ 0x7C*8+2;
extern volatile sbit CONFLASH_3                @ 0x7C*8+3;
extern volatile sbit CONFLASH_4                @ 0x7C*8+4;
extern volatile sbit CONFLASH_5                @ 0x7C*8+5;

#endif
